#include <stdio.h>
#include <string.h>

// AIX2ADX 0.0
// by hcs

// get 16-bit big endian value
int get16bit(unsigned char* p)
{
    return (p[0] << 8) | p[1];
}

// get 32-bit big endian value
int get32bit(unsigned char* p)
{
    return (p[0] << 24) | (p[1] << 16) | (p[2] << 8) | p[3];
}

int main(int argc, char ** argv) {
    FILE * infile, * outfile = NULL;
    int channel, chancount, frame, samplerate, size;
    int channeltocopy,curaix,nextaix,done,i;
    char buf[0x24],namebase[256],filename[256+4];
    char *t;

    printf("AIX2ADX 0.0 by hcs\n");

    if (argc != 2) {printf("usage: %s AIXFILE.AIX\n",argv[0]); return 1;}
    infile = fopen(argv[1],"rb");
    if (!infile) {printf("error opening %s\n",argv[1]); return 1;}

    // generate namebase
    t=strrchr(argv[1],'\\');
    if (!t) t=argv[1];
    else t++;
    for (i=0;t<strrchr(argv[1],'.');t++,i++) namebase[i]=*t;
    namebase[i]='\0';

    for (channeltocopy=0;channeltocopy>=0;channeltocopy++) {

    fseek(infile,0,SEEK_SET);
    curaix=0;
    done = 0;
  
    while (!done) {
        fread(buf,8,1,infile);

        if (memcmp(buf,"AIX",3)) {printf("malformed AIX header at %08x (bad signature)\n",curaix); return 1;}

        nextaix=curaix+8+get32bit(buf+0x4);

        switch (buf[3]) {
        case 'F':
            printf("file header\n");
            break;
        case 'E':
            printf("end of file\n");
            done = 1;
            break;
        case 'P':
            fread(buf,8,1,infile);
            channel = buf[0];
            chancount = buf[1];
            frame = get32bit(buf+4);
            size = get16bit(buf+2);

            if (channeltocopy >= chancount) {channeltocopy=-2; done=1; break;}

            if (channel==channeltocopy) {
                if (!outfile) {
                    sprintf(filename,"%s%04d.adx",namebase,channel);
                    outfile=fopen(filename,"wb");
                    if (!outfile) {printf("error opening %s\n",filename); return 1;}
                }
                printf("channel #%d/%d\tframe #%d\tsize: %#08x\n",channel,chancount-1,frame,size);
                for (i=0;i<size;i++) {
                    fread(buf,1,1,infile);
                    fwrite(buf,1,1,outfile);
                }
            }
            break;
        default:
            printf("malformed AIX header at %08x (bad type)\n",curaix);
        }

        fseek(infile,nextaix,SEEK_SET);
        curaix=nextaix;
    }

    if (outfile) {fclose(outfile); outfile=NULL;}

    }

    return 0;
}
